<?php
function add_esxi_vswitch($argv) {
	/* check number of arguments */
	if(count($argv) != 4) {
		echo "Usage: add_esxi_vswitch ESXI_HOST ESXI_USERNAME ESXI_PASSWORD VSWITCH_NAME\n";
		exit(1);
	}

	/* fetch arguments */
	$esxi_host = escapeshellarg($argv[0]);
	$esxi_username = escapeshellarg($argv[1]);
	$esxi_password = escapeshellarg($argv[2]);
	$vswitch_name = escapeshellarg($argv[3]);

	/* execute main function */
	unset($result_array);
	exec("vicfg-vswitch --server $esxi_host --username $esxi_username --password $esxi_password --check $vswitch_name 2>&1", $result_array, $return_value);
	if($return_value != 0) {
		echo "vicfg-vswitch error\n";
		exit(1);
	}

	/* the vswitch already exist */
	if($result_array[0] == 1) {
		exit(0);
	}

	unset($result_array);
	exec("vicfg-vswitch --server $esxi_host --username $esxi_username --password $esxi_password --add $vswitch_name 2>&1", $result_array, $return_value);
	foreach($result_array as $line) {
		echo $line . "\n";
	}
	exit($return_value);
}

